function test_suite = testConstructor %#ok<*STOUT>
%This suite tests all functions of the constructor that are not tested
%separately for set/get methods.
initTestSuite;

function testNoArguments %#ok<*DEFNU>
out = BertiniLab;
assert(isprop(out,'config'))
assert(isprop(out,'function_def'))
assert(isprop(out,'variable_group'))
assert(isprop(out,'hom_variable_group'))
assert(isprop(out,'pathvariable'))
assert(isprop(out,'parameter'))
assert(isprop(out,'constant'))
assert(isprop(out,'subfunction'))
assert(isprop(out,'solve_summary'))

assertEqual(out.config,struct)
assertEqual(out.function_def,polysym.empty)
assertEqual(out.variable_group,polysym.empty)
assertEqual(out.hom_variable_group,polysym.empty)
assertEqual(out.pathvariable,polysym.empty)
assertEqual(out.parameter,polysym.empty(0,2))
assertEqual(out.constant,polysym.empty(0,2))
assertEqual(out.subfunction,polysym.empty(0,2))
assertEqual(out.solve_summary,'')

function testSingleArgument
f = @() BertiniLab('config');
assertExceptionThrown(f,'BertiniLab:Constructor:notPaired')

function testsThreeArgs
f = @() BertiniLab('variable_group',polysym({'x','0'}),'variable_group');
assertExceptionThrown(f,'BertiniLab:Constructor:notPaired')

function testRedundantAssignment
out = BertiniLab('variable_group',polysym({'x','0'}), ...
    'variable_group',polysym({'x','1'}));
assertEqual(out.variable_group,polysym({'x','1'}))

function testSameAsSet
out1 = BertiniLab('variable_group',polysym({'x','1'}));
out2 = BertiniLab;
out2.variable_group = polysym({'x','1'});
assertEqual(out1,out2)

function testSetProtected
out = BertiniLab('solve_summary',3);
assertEqual(out.solve_summary,3)
